﻿<?LassoScript

	// Multi-column info leaflet PDF demo for Lasso Summit 2007
	// Author Jolle Carlestam
	// With the help of solutions suggested in Lasso Talk
	// Use and alter freely but please keep this info




	// Preparation of demo content. This should be replaced with your
	// own record content handling.
	// the demo assumes that the files ex_cont/Leaflet.incl,
	// ex_cont/jina_prepPDF_demo.incl, ex_cont/MultiColumnTemplate.pdf,
	// ex_cont/summit07banner.jpg and ex_cont/leafletImg1.jpg (or 
	// leafletImg2.jpg) are in the same folder and can be accessed by Lasso.
	Include:'ex_cont/jina_prepPDF_demo.incl';
	var:'leafletData' = jina_prepDemoContent: (Include:'ex_cont/Leaflet.incl');



	//#####################################################################//
	// Settings that control the look and layout of the invoice pages.
	// These demo settings are suitable for an A4 page.

	// These variables set the font face and leading.
	var:'headingFont' = (pdf_font: -face = 'Helvetica-Bold', -size = 22, -color = '#929297');
	var:'plainFont' = (pdf_font: -face = 'Times-Roman', -size = 12, -color = '#000000');
	var:'preambleFont' = (pdf_font: -face = 'Times-Italic', -size = 14, -color = '#000000');
	var:'imgTextFont' = (pdf_font: -face = 'Times-Italic', -size = 11, -color = '#000000');
	var:'smallPlainFont' = (pdf_font: -face = 'Times-Roman', -size = 10, -color = '#FFFFFF');
	var:'smallBoldFont' = (pdf_font: -face = 'Times-Bold', -size = 10, -color = '#FFFFFF');

	var:'headingLeading' = 24;
	var:'preambleLeading' = 16;
	var:'imgTextLeading' = 12;
	var:'textLeading' = 13;
	var:'smallTextLeading' = 16;

	var:'BkgPDF' = 'ex_cont/MultiColumnTemplate.pdf';
	var:'logoImgPath' = 'ex_cont/summit07banner.jpg';

	var:'pageSize' = 'A4';
	var:'pageHeight' = 842;
	var:'pageWidth' = 595;

	var:'marginLeft' = 20;
	var:'marginTop' = 40;
	var:'marginBottom' = 40;


	// The left and width of each column.
	var:'col1Left' = 0; // Relative to the page left margin.
	var:'col1Width' = 170;
	
	var:'col2Left' = 200; // Relative to the page left margin.
	var:'col3Left' = 392; // Relative to the page left margin.

	var:'artColWidth' = 163; // Same for col2 and col3.

	var:'imgColExtra' = 54; // To be added to col if image width > height.

	var:'col2Col3Combined' = 345; // Width used by headline and preamble.


	//#####################################################################//
	// Vars set to be used by the application. Do not change these.
	var:'itemRaw' = array;
	var:'tempTextCont' = string;
	var:'textVerSize' = string;
	var:'tempContainer' = string;
	var:'imgColWidth' = integer;
	var:'wordTemp' = string;
	var:'thisTextRow' = string;
	var:'thisRowNo' = integer;
	var:'logoImgInfo'= null;
	var:'logoImgWidth' = integer;
	var:'logoImgHeight' = integer;
	var:'sizeFactor' = decimal;
	var:'articleImgInfo'= null;
	var:'articleImgWidth' = integer;
	var:'articleImgHeight' = integer;
	var:'thisColWidth' = integer;
	var:'thisColTop' = integer;
	var:'imgRowHeight' = integer;
	var:'colcount' = integer;
	var:'col2Space' = integer;
	var:'col3Space' = integer;
	var:'imgNotPassed' = false;
	

	var:'col1Top' = $marginTop;
	var:'col2Top' = $marginTop;
	var:'col3Top' = $marginTop;
	var:'thisColLeft' = $marginLeft + $col2Left;


	var:'leftColContent' = (PDF_Text:'', -Type='Paragraph', 
		-Font = $smallBoldFont);

	
	// Create the PDF file.
	var:'pdfTemplate' = (pdf_doc:
		-nocompress,
		-size = $pageSize,
		-title = 'leaflet',
		-author = 'jinaOnline',
		-margins = (array: 0,0,0,0)
		);

	// Insert the background pdf page.
	$pdfTemplate->(insertpage: (pdf_read:
		-file = $BkgPDF), 1);


	// Placing a logo image in left column.
	if:(File_Exists: $logoImgPath);
		$logoImgInfo= (Image: $logoImgPath, -Info);
		$logoImgWidth = $logoImgInfo->Width;
		$logoImgHeight = $logoImgInfo->Height;
		// Reduce the image so it fits into the column.
		$sizeFactor = decimal($col1Width) / decimal($logoImgWidth);
		$logoImgHeight = (Integer:($logoImgHeight * $sizeFactor));

		$pdfTemplate->(Add:(PDF_Image:-File= $logoImgPath),
			-left = $marginLeft + $col1Left,
			-width = (Integer:($logoImgWidth * $sizeFactor)),
			-top = $col1Top + $logoImgHeight,
			-height = $logoImgHeight);

		// Adjust vertical position.
		$col1Top += $logoImgHeight + 10;

	/if;

	// Create left col fact text.
	iterate: $leafletData->'demoItems', $itemRaw;
		$leftColContent->(Add:(PDF_Text:$itemRaw->(Get:1) + ':  ',
			-Font = $smallBoldFont));
		$leftColContent->(Add:(PDF_Text:$itemRaw->(Get:2) + '\r',
			-Font = $smallPlainFont));
	/iterate;

	// Add left col fact text.
	$pdfTemplate->(Add:$leftColContent,
		-left = $marginLeft + $col1Left, 
		-width = $col1Width,
		-top = $col1Top,
		-height = $pageHeight - $marginTop - $marginBottom,
		-align = 'left', 
		-leading = $smallTextLeading);

	// Add headline for article.
	$pdfTemplate->(Add:(PDF_Text:($leafletData->'headingContent'),
		-type='Paragraph', 
		-font = $headingFont),
		-left = $marginLeft + $col2Left, 
		-width = $col2Col3Combined,
		-top = $col2Top,
		-align = 'left', 
		-leading = $headingLeading);

	// Check vertical space for the headline.
	$tempTextCont = $leafletData->'headingContent'->(Split:'\r');

	$textVerSize = $tempTextCont->Size; // This gives us all hardcoded line feeds.
	iterate: $tempTextCont, $tempContainer;
		// This adds vertical space if the content flows over more than one row.
		$textVerSize += math_floor(($headingFont->(textwidth: $tempContainer)) / $col2Col3Combined);
	/iterate;

	// Adjust vertical position.
	$col2Top += ($textVerSize * $headingLeading) + ($headingLeading / 2);

	// Add preamble text.
	$pdfTemplate->(Add:(PDF_Text:($leafletData->'preambleContent'),
		-type='Paragraph', 
		-font = $preambleFont),
		-left = $marginLeft + $col2Left, 
		-width = $col2Col3Combined,
		-top = $col2Top,
		-align = 'left', 
		-leading = $preambleLeading);

	// Check vertical space for the preamble.
	$tempTextCont = $leafletData->'preambleContent'->(Split:'\r');

	$textVerSize = $tempTextCont->Size; // This gives us all hardcoded line feeds.
	iterate: $tempTextCont, $tempContainer;
		// This adds vertical space if the content flows over more than one row.
		$textVerSize += math_floor(($preambleFont->(textwidth: $tempContainer)) / $col2Col3Combined);
	/iterate;

	// Adjust vertical position.
	$col2Top += (($textVerSize + 1) * $preambleLeading);
	$col3Top = $col2Top;

	// Placing Image.
	if:(File_Exists: $leafletData->'imgPath');
		$articleImgInfo = (Image: $leafletData->'imgPath', -Info);
		$articleImgWidth = $articleImgInfo->Width;
		$articleImgHeight = $articleImgInfo->Height;
		// Reduce the image so it fits. If image is portrait oriented then 
		// extra width will be used moving the picture into the left column.
		$imgColWidth = $artColWidth + (($articleImgWidth > $articleImgHeight) ? $imgColExtra | 0); // Adding px to column width if image width > image height.

		$sizeFactor = decimal($imgColWidth) / decimal($articleImgWidth);

		$articleImgHeight = (Integer:($articleImgHeight * $sizeFactor));

		$pdfTemplate->(Add:(PDF_Image:-File= $leafletData->'imgPath'),
			-left = $marginLeft + $col3Left + $artColWidth - $imgColWidth,
			-width = (Integer:($articleImgWidth * $sizeFactor)),
			-top = $col3Top + $articleImgHeight,
			-height = $articleImgHeight);

		// Adjust vertical position.
		$col3Top += $articleImgHeight + $preambleLeading;

		// Add image text.
		$pdfTemplate->(Add:(PDF_Text:($leafletData->'imgTextContent'),
			-type='Paragraph', 
			-font = $imgTextFont),
			-left = $marginLeft + $col3Left + $artColWidth - $imgColWidth,
			-width = $imgColWidth,
			-top = $col3Top - 14,
			-align = 'left', 
			-leading = $imgTextLeading);

		// Check vertical space for the image text.
		$tempTextCont = $leafletData->'imgTextContent'->(Split:'\r');

		$textVerSize = $tempTextCont->Size; // This gives us all hardcoded line feeds.
		iterate: $tempTextCont, $tempContainer;
			// This adds rows if the content flows over more than one row.
			$textVerSize += math_floor(($imgTextFont->(textwidth: $tempContainer)) / $imgColWidth);
		/iterate;

		// Adjust vertical position.
		$col3Top += ($textVerSize * $imgTextLeading);
		$imgNotPassed = true;

	/if;

	// Prepare the article text.
	$tempTextCont = $leafletData->'articleContent';

	$tempTextCont->(Replace: '\n', '\r'); // Some cleaning of input.
	$tempTextCont->(Replace: '\r\n', '\r');
	$tempTextCont->(removeTrailing:'\r');
	$tempTextCont = $tempTextCont->(Split:'\r');

	// Set column width. Adjust for a potential image reducing col width.
	$thisColWidth = $artColWidth - (($articleImgWidth > $articleImgHeight) ? ($imgColExtra - 14) | 0);

	// Set initial column position for present column.
	$thisColTop = $col2Top;
	$imgRowHeight = ($col3Top - $col2Top);
	$col2Space = ($pageHeight - $col2Top);
	$col3Space = ($pageHeight - $col3Top);
	$colcount = 2;

	// Iterate each paragraph.
	iterate: $tempTextCont, $tempContainer;
		// Iterate each word within the paragraph.
		// This is needed in order to know when to change column settings.
		iterate: $tempContainer->(Split:' '), $wordTemp;
			if:($plainFont->(TextWidth:($thisTextRow + $wordTemp))) < $thisColWidth; // The next word fits within the present row.
				$thisTextRow += $wordTemp + ' ';
			else; // Word doesn't fit. Time to add the row to the pdf.

				$pdfTemplate->(Add:(PDF_Text:$thisTextRow,
					-type='Paragraph', 
						-Font = $plainFont),
					-left = $thisColLeft,
					-width = $thisColWidth,
					-top = $thisColTop,
					-align = 'left', 
					-leading = $textLeading);

				// Decrease vertical space count to know when to alter column settings.
				$col2Space -= $textLeading; 

				 // Text passed image pos. Time to adjust col settings.
				 if:($thisColTop >= $col3Top - 15) && $imgNotPassed;
					$thisColWidth = $artColWidth;
					$thisColTop += $textLeading;
					$imgNotPassed = false;


					// Set right column to adjust with present row height.
					$col3Top = $thisColTop;

				 // Text filled column. Time to move to the right.
				 else:($col2Space < $marginBottom) && $colCount == 2;
					$thisColTop = $col3Top;
					$col2Space = $col3Space;
					$thisColLeft = $marginLeft + $col3Left;
					$colcount += 1;
				else;
					$thisColTop += $textLeading;
				/if;

				// Add the present word to the empty present row.
				$thisTextRow = $wordTemp + ' ';
			/if;
		/iterate;

		// There's probably content in the row var.
		// Add it before moving to next paragraph.
		$pdfTemplate->(Add:(PDF_Text:$thisTextRow, -Type='Paragraph', 
			-font = $plainFont),
			-left =  $thisColLeft, 
			-width = $thisColWidth,
			-top = $thisColTop,
			-align = 'left', 
			-leading = $textLeading);

		// Add som space since we're starting a new paragraph.
		$thisColTop += 6;

		$col2Space -= $textLeading; 
		$col2Space -= 6; 


		$thisTextRow = string;

		// It's possible that the last row pushed the text to
		// a trigger position. Act on that, just in case.
		 if:($thisColTop >= $col3Top - 15) && $imgNotPassed;
			$thisColWidth = $artColWidth;
			$thisColTop += $textLeading;
			$imgNotPassed = false;
			$col3Top = $thisColTop;
		 else:($col2Space < $marginBottom) && $colCount == 2;
			$thisColTop = $col3Top;
			$col2Space = $col3Space;
			$thisColLeft = $marginLeft + $col3Left;
			$colcount += 1;
		else;
			$thisColTop += $textLeading;
		/if;

	/iterate;


// Serve the PDF.
	$pdfTemplate->close;
	pdf_serve: -content = $pdfTemplate, -file = 'Jina Demo Leaflet.pdf';

?>